/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

/*
 * Initialisation
 */
static void FN_DataTables_Init() {
  int a;

  /* Clear pointertable */
  for(a = 0; a < 256; a++) pPointerTable[a] = NULL;
  for(a = 0; a < KEY2COUNT_B; a++)/* link two-character strings (bytes) */
    FN_DataTables_Next((ListItem *) &pKeyTable2_B[a], 2);
  for(a = 0; a < KEY3COUNT_B; a++)/* link three-character strings (bytes) */
    FN_DataTables_Next((ListItem *) &pKeyTable3_B[a], 3);
  for(a = 0; a < KEY4COUNT_B; a++)/* link four-character strings (bytes) */
    FN_DataTables_Next((ListItem *) &pKeyTable4_B[a], 4);
  for(a = 0; a < KEY5COUNT_B; a++)/* link five-character strings (bytes) */
    FN_DataTables_Next((ListItem *) &pKeyTable5_B[a], 5);

  for(a = 0; a < KEY2COUNT_P; a++)/* link two-character strings (pointers) */
    FN_DataTables_Next((ListItem *) &pKeyTable2_P[a], 2);
  for(a = 0; a < KEY3COUNT_P; a++)/* link three-character strings (pointers) */
    FN_DataTables_Next((ListItem *) &pKeyTable3_P[a], 3);
  for(a = 0; a < KEY4COUNT_P; a++)/* link four-character strings (pointers) */
    FN_DataTables_Next((ListItem *) &pKeyTable4_P[a], 4);
  for(a = 0; a < KEY5COUNT_P; a++)/* link five-character strings (pointers) */
    FN_DataTables_Next((ListItem *) &pKeyTable5_P[a], 5);
  for(a = 0; a < KEY6COUNT_P; a++)/* link six-character strings (pointers) */
    FN_DataTables_Next((ListItem *) &pKeyTable6_P[a], 6);
  for(a = 0; a < KEY7COUNT_P; a++)/* link seven-character strings (pointers) */
    FN_DataTables_Next((ListItem *) &pKeyTable7_P[a], 7);

  for(a = 0; a < OUTBUFFERSIZE; a++)/* Clear output buffer */
    OutputBuffer[a] = MEMFILL;
}

/*
 * Utility routine
 */
static void FN_DataTables_Next(ListItem *p, int len) {
  ListItem      *t;
  unsigned char  Hash = FN_Struct_Hash(p, len + 1);/* type + string */

#ifdef FDEBUG
  pHashTestTable[Hash]++;
#endif
  t = (ListItem *) &pPointerTable[Hash];/* point to first pointer */
  while(t->Next) {
    if((t->Next)->Hash > p->Hash) break;
    t = t->Next;
  }
  p->Next = t->Next;
  t->Next = p;
}
